package types;

public class DataClass extends java.lang.Object implements Cloneable {
    // Constants

    int lowerBound;
    int upperBound;
    int sequenceNumbers;
    int maxWindowSize;
    public DataClass(int sequenceNumber,int windowSize) {
        lowerBound=0;
        upperBound=windowSize;
        sequenceNumbers=sequenceNumber;
        maxWindowSize=windowSize;
    }
    public void incLowerBound() {
        lowerBound = (lowerBound+1)%sequenceNumbers;
    }
    public void incUpperBound() {
        upperBound = (upperBound+1)%sequenceNumbers;
    }
    public void incLowerBound(int iAnz) {
        lowerBound = (lowerBound+iAnz)%sequenceNumbers;
        if (lowerBound<0)
            lowerBound+=sequenceNumbers;
    }
    public void incUpperBound(int iAnz) {
        upperBound = (upperBound+iAnz)%sequenceNumbers;
        if (upperBound<0)
            upperBound+=sequenceNumbers;
    }
    public int windowSize() {
        int space=upperBound-lowerBound;
        if (space<0)
            space+=sequenceNumbers;
        return(space);
    }
    public int windowSizeInvers() {
        int space=upperBound-lowerBound;
        if (space<0)
            space+=sequenceNumbers;
        return(maxWindowSize-space);
    }
    public int lowerBound() {
        return(lowerBound);
    }
    public void lowerBound(int lb) {
        lowerBound = lb;
    }
    public int upperBound() {
        return(upperBound);
    }
    public void upperBound(int ub) {
        upperBound = ub;
    }
    public int maxWindowSize() {
        return(maxWindowSize);
    }
    public int sequenceNumbers() {
        return(sequenceNumbers);
    }
    public boolean isInWindow(int iTest) {
        int iNum = iTest%sequenceNumbers;
        if (upperBound>=lowerBound) {
            return((iNum>=lowerBound)&&(iNum<=upperBound));
        }
        else {
            return((iNum>=lowerBound)||(iNum<=upperBound));
        }
    }
    public boolean isBetween(int iStart,int iEnde,int iTest) {
        int iNum = iTest%sequenceNumbers;
        if (iEnde>=iStart) {
            return((iNum>=iStart)&&(iNum<iEnde));
        }
        else {
            return((iNum>=iStart)||(iNum<iEnde));
        }
    }
    public int subtract(int iWert1,int iWert2) {
        int iTest = iWert1-iWert2;
        if (iTest<0)
            return(iTest+sequenceNumbers);
        else
            return(iTest);
    }
    public int add(int iWert1,int iWert2) {
        return((iWert1+iWert2)%sequenceNumbers);
    }

    public Object clone() throws CloneNotSupportedException {
        return(super.clone());
    }
    public boolean equals(DataClass data) {
        return((lowerBound==data.lowerBound)&&
               (upperBound==data.upperBound));
    }
}

